<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $faqs = Faq::all();
        return view('dashboard.faq.index', compact('faqs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('dashboard.faq.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $request->validate([
            'question_en'           => 'bail|required|max:200',
            'question_ar'           => 'bail|required|max:200',
            //'question_de'           => 'bail|required|max:200',
            'answer_en'             => 'bail|required',
            'answer_ar'             => 'bail|required',
            //'answer_de'             => 'bail|required',
        ], [], [
            'question_en'           => ' Question in English',
            'question_ar'           => ' Question in Arabic',
            'question_de'           => ' Question in German',
            'answer_en'             => ' Answer in English',
            'answer_ar'             => ' Answer in Arabic',
            'answer_de'             => ' Answer in German',
        ]);

        $faq = new Faq();
        if ($faq->save())
        {
            $faq->faq_ar()->create(['faq_id' => $faq->id ,'question' => $input['question_ar'], 'answer' => $input['answer_ar']]);
            $faq->faq_en()->create(['faq_id' => $faq->id ,'question' => $input['question_en'], 'answer' => $input['answer_en']]);
        }

        Session::flash('create', 'FAQ Has Been Created Successfully');
        return redirect(adminUrl('faq'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $faq = Faq::find($id);
        return view('dashboard.faq.edit', compact('faq'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $faq = Faq::find($id);
        $request->validate([
            'question_en'           => 'bail|required|max:200',
            'question_ar'           => 'bail|required|max:200',
            //'question_de'           => 'bail|required|max:200',
            'answer_en'             => 'bail|required',
            'answer_ar'             => 'bail|required',
            //'answer_de'             => 'bail|required',
        ], [], [
            'question_en'           => ' Question in English',
            'question_ar'           => ' Question in Arabic',
            'question_de'           => ' Question in German',
            'answer_en'             => ' Answer in English',
            'answer_ar'             => ' Answer in Arabic',
            'answer_de'             => ' Answer in German',
        ]);

        $faq->save();

        $faq->faq_ar()->update(['faq_id' => $faq->id ,'question' => $input['question_ar'], 'answer' => $input['answer_ar']]);
        $faq->faq_en()->update(['faq_id' => $faq->id ,'question' => $input['question_en'], 'answer' => $input['answer_en']]);
        //$faq->faq_de()->update(['faq_id' => $faq->id ,'question' => $input['question_de'], 'answer' => $input['answer_de']]);

        Session::flash('create', 'FAQ Has Been Updated Successfully');
        return redirect(adminUrl('faq'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $faq = Faq::find($id);
        $faq->delete();
        Session::flash('delete', 'FAQ Has Been Deleted Successfully');
        return redirect(adminUrl('faq'));
    }
}
