<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\Form;
use App\Models\Image;
use App\Models\Open_graph;
use App\Models\Page;
use App\Models\Service;
use App\Models\Video;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $type = Input::get('type');
        if ($type == 'success-story')
        {
            $services = Service::with('service_en', 'createdBy', 'image')->where('parent_service_id', '=', null)->where('status','=','success-story')->get();

            return view('dashboard.service.index', compact('services'));

        }
        else if ($type == 'medical-tourism')
        {
            $services = Service::with('service_en', 'createdBy', 'image')->where('parent_service_id', '=', null)->where('status','=','medical-tourism')->get();
            return view('dashboard.service.index', compact('services'));
        }else{
            $services = Service::with('service_en', 'createdBy', 'image')->where('parent_service_id', null)->where('status','=',null)->get();
            return view('dashboard.service.index', compact('services'));
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('dashboard.service.create');
    }

    public function storeSub(Request $request)
    {
        $input = $request->all();
        $input['created_by'] = Auth::user()->id;
        $request->validate([
            'title_en'          => 'bail|required|max:200',
            'service_id'        => 'bail|required|int|max:200',
            //'video_url'         => 'bail|max:300',
            'url'               => 'bail|unique:service|max:190',
            'description_en'    => 'bail|required',
            //'slug_en'           => 'bail|required|max:300',
            'title_ar'          => 'bail|required|max:200',
            'description_ar'    => 'bail|required',
            //'slug_ar'           => 'bail|required|max:300',
            'image_id'          => 'bail|required|mimes:jpeg,jpg,png,gif',
        ], [], [
            'title_en'          => ' Title in English',
            'description_en'    => ' Description in English',
            //'slug_en'           => ' Slug in English',
            'title_ar'          => ' Title in Arabic',
            'description_ar'    => ' Description in Arabic',
            //'slug_ar'           => ' Slug in Arabic',
            'image_id'          => ' Image',
            'video_url'         => ' Video Url'
        ]);


        //Upload Service Image
        if ($uploadedFile = $request->file('image_id'))
        {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/service', $fileName);
            $filePath = 'dashboardImages/service/'.$fileName;
            $image = Image::create(['name' => $fileName, 'path' => $filePath, 'alt' => $input['img_alt']]);
            $input['image_id'] = $image->id;
        }

        //Save Video in videos table
        $video = new Video();
        if ($input['video_url'] != null)
        {
            $video->url = $input['video_url'];
            $video->save();
        }
        else
        {
            //set video url value to null if empty
            $video->url = null;
            $video->save();
        }

        if (empty($input['url']))
        {
            $input['url'] = str_slug($input['title_en']);
        }

        //Create ne open graph info for service
        $open_graph = new Open_graph();
        $open_graph->og_title = $input['title_en'];
        $open_graph->og_image = $input['image_id'];
        $open_graph->og_description = $input['description_en'];
        $open_graph->og_url =  $input['url'];
        $open_graph->save();

        //Create new page info for service
        $page = new Page();
        $page->url = $input['url'];
        $page->name = $input['title_en'];
        $page->open_graph_id = $open_graph->id;
        $page->save();

        //Create new form for this service
        $form = new Form();
        $form->name = $input['title_en'];
        //$form->page_id = $page->id;
        $form->save();

        //Save All Data in service table
        $service = new Service();
        $service->image_id = $input['image_id'];
        $service->created_by = $input['created_by'];
        $service->url = $input['url'];
        $service->video_id = $video->id;
        $service->page_id = $page->id;
        $service->open_graph_id = $open_graph->id;
        $service->form_id = $form->id;
        $service->parent_service_id = $input['service_id'];
        $service->save();

        //Save Services in English and Arabic With Eloquent
        $service->service_ar()->create(['service_id' => $service->id, 'title' => $input['title_ar'], 'description' => $input['description_ar'], 'slug' => $input['slug_ar']]);
        $service->service_en()->create(['service_id' => $service->id, 'title' => $input['title_en'], 'description' => $input['description_en'], 'slug' => $input['slug_en']]);

        Session::flash('create', 'Service  Has Been Created Successfully');
        return redirect(adminUrl('service/'.$input['service_id']));
    }


    public function createSubService($id)
    {
        $service = Service::with('image', 'service_en', 'createdBy')->find($id);
        return view('dashboard.service.createSub', compact('service'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $input['created_by'] = Auth::user()->id;
        $request->validate([
            'title_en'          => 'bail|required|max:200',
            'description_en'    => 'bail|required',
            'url'               => 'bail|unique:service|max:190',
            //'slug_en'           => 'bail|required|max:300',
            'title_ar'          => 'bail|required|max:200',
            'description_ar'    => 'bail|required',
            //'slug_ar'           => 'bail|required|max:300',
            'image_id'          => 'bail|required|mimes:jpeg,jpg,png,gif',
        ], [], [
            'title_en'          => ' Title in English',
            'description_en'    => ' Description in English',
            'slug_en'           => ' Slug in English',
            'title_ar'          => ' Title in Arabic',
            'description_ar'    => ' Description in Arabic',
            'slug_ar'           => ' Slug in Arabic',
            'image_id'          => ' Image',
        ]);


        //Upload Slide Image
        if ($uploadedFile = $request->file('image_id'))
        {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/service', $fileName);
            $filePath = 'dashboardImages/service/'.$fileName;
            $image = Image::create(['name' => $fileName, 'path' => $filePath, 'alt' => $input['img_alt']]);
            $input['image_id'] = $image->id;
        }

        //Save Video in videos table
       /* $video = new Video();
        if ($input['video_url'] != null)
        {
            $video->url = $input['video_url'];
            $video->save();
        }
        else
        {
            //set video url value to null if empty
            $video->url = null;
            $video->save();
        }*/

        if (empty($input['url']))
        {
            $input['url'] = str_slug($input['title_en']);
        }


        //Create ne open graph info for service
        $open_graph = new Open_graph();
        $open_graph->og_title = $input['title_en'];
        $open_graph->og_image = $input['image_id'];
        $open_graph->og_description = $input['description_en'];
        $open_graph->og_url =  $input['url'];
        $open_graph->save();

        //Create new page info for service
        $page = new Page();
        $page->url = $input['url'];
        $page->name = $input['title_en'];
        $page->open_graph_id = $open_graph->id;
        $page->save();

        //Create new form for this service
        $form = new Form();
        $form->name = $input['title_en'];
        //$form->page_id = $page->id;
        $form->save();

        //Save All Data in service table
        $service = new Service();
        $service->image_id = $input['image_id'];
        $service->created_by = $input['created_by'];
        $service->url = $input['url'];
        //$service->video_id = $video->id;
        $service->status = $request->status ? $request->status : null;
        $service->page_id = $page->id;
        $service->open_graph_id = $open_graph->id;
        $service->form_id = $form->id;
        $service->save();

        $service->service_ar()->create(['service_id' => $service->id, 'title' => $input['title_ar'], 'description' => $input['description_ar']/*, 'slug' => $input['slug_ar']*/]);
        $service->service_en()->create(['service_id' => $service->id, 'title' => $input['title_en'], 'description' => $input['description_en']/*, 'slug' => $input['slug_en']*/]);

        Session::flash('create', 'Service  Has Been Created Successfully');
        return redirect(adminUrl('service?type='.$service->status));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $mainService =  Service::with('image', 'service_en', 'createdBy')->find($id);
        $services = Service::with('image', 'service_en', 'createdBy')->where('parent_service_id', $id)->get();
        return view('dashboard.service.subService', compact('services', 'mainService'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service::with('image', 'service_en', 'createdBy')->find($id);
        return view('dashboard.service.edit', compact('service'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $service = Service::with('service_en', 'createdBy', 'image')->find($id);
        $input['created_by'] = Auth::user()->id;
        $request->validate([
            'title_en'          => 'bail|required|max:200',
            'url'               => 'bail|unique:service,url,'. $id .'|max:200',
            'description_en'    => 'bail|required',
            //'slug_en'           => 'bail|required|max:300',
            'title_ar'          => 'bail|required|max:200',
            'description_ar'    => 'bail|required',
            //'slug_ar'           => 'bail|required|max:300',
            'img_alt'           => 'required',
            'image_id'          => 'mimes:jpeg,jpg,png,gif',
        ], [], [
            'title_en'          => ' Title in English',
            'description_en'    => ' Description in English',
            //'slug_en'           => ' Slug in English',
            'title_ar'          => ' Title in Arabic',
            'description_ar'    => ' Description in Arabic',
            //'slug_ar'           => ' Slug in Arabic',
            'image_id'          => ' Image',
        ]);

        //Upload Slide Image
        if ($uploadedFile = $request->file('image_id'))
        {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/service', $fileName);
            $filePath = 'dashboardImages/service/'.$fileName;
            $image = Image::create(['name' => $fileName, 'path' => $filePath, 'alt' => $input['img_alt']]);
            $input['image_id'] = $image->id;
            $service->image_id = $input['image_id'];
        }
        else
        {
            $input['image_id'] = $service->image_id;
        }

        /*if ($input['video_url'])
        {
            $video = Video::find($service->video_id);
            if ($video)
            {
                $video->url = $input['video_url'];
                $video->save();
            }
            else
            {
                $video = new Video();
                $video->url = $input['video_url'];
                $video->save();
                $service->video_id = $video->id;
            }
        }

        elseif (empty($input['video_url']))
        {
            $service->video_id = null;
        }

        if (empty($input['url']))
        {
            $input['url'] = str_slug($input['title_en']);
        }*/

        //check if service have open graph tags
        if ($service->open_graph_id == null)
        {
            $open_graph = new Open_graph();
            $open_graph->og_title = $input['title_en'];
            $open_graph->og_image = $input['image_id'];
            $open_graph->og_description = $input['description_en'];
            $open_graph->og_url =  $input['url'];
            $open_graph->save();

            //Create new page info for service
            $page = new Page();
            $page->url = $input['url'];
            $page->name = $input['title_en'];
            $page->open_graph_id = $open_graph->id;
            $page->save();

            //Create new form for this service
            $form = new Form();
            $form->name = $input['title_en'];
            $form->save();

            $service->url = $input['url'];
            $service->open_graph_id = $open_graph->id;
            $service->form_id = $form->id;
            $service->page_id = $page->id;
            $service->created_by = $input['created_by'];
            $service->save();

            $service->service_ar()->update(['service_id' => $service->id, 'title' => $input['title_ar'], 'description' => $input['description_ar']/*, 'slug' => $input['slug_ar']*/]);
            $service->service_en()->update(['service_id' => $service->id, 'title' => $input['title_en'], 'description' => $input['description_en']/*, 'slug' => $input['slug_en']*/]);
        }
        else
        {
            $service->url = $input['url'];
            $service->created_by = $input['created_by'];
            $service->save();
            $service->service_ar()->update(['service_id' => $service->id, 'title' => $input['title_ar'], 'description' => $input['description_ar']/*, 'slug' => $input['slug_ar']*/]);
            $service->service_en()->update(['service_id' => $service->id, 'title' => $input['title_en'], 'description' => $input['description_en']/*, 'slug' => $input['slug_en']*/]);
            $service->image()->update(['alt' => $input['img_alt']]);
            $service->page()->update(['url' => $input['url']]);
            $service->openGraph()->update(['og_url' => $input['url']]);
        }

        Session::flash('update', 'Service Has Been Updated Successfully');
        return redirect(adminUrl('service?type='.$service->status));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $service = Service::with('service_en', 'service_ar')->find($id);

        $service->delete();

        $service->page()->delete();

        $service->openGraph()->delete();

        try
        {
            if ($service->image_id)
            {
                unlink(public_path() . '/' . $service->image->path);
                DB::table('image')->where('id', $service->image_id)->delete();
            }
        }
        catch (\Exception $e)
        {
            Session::flash('exception', 'Error, Can\'t Delete Slide Because The Slide is related to another table');
            return redirect()->back();
        }

        Session::flash('delete', 'Service ' . $service->id . ' Has Been Deleted Successfully');
        return redirect(adminUrl('service?type='.$service->status));
    }

    public function showImages($id){
        $service=Service::find($id);
        return view("dashboard.service.show",compact('service'));
    }
    public function destroyServiceImage(Request $request, $id)
    {
        $service=Service::find($id);
        $image = $request->image;
        $image_id = $request->image_id;
        $image_path = public_path("/dashboardImages/service/" . $image);
        if (\File::exists($image_path)) {
            unlink($image_path);
        } else {
        }
        //$image_id=$service->images[0]->pivot->image_id;
        //$imageData=Image::where("id",$image_id)->where("name", $image)->first();
        $imageData=Image::where("id",$image_id)->where("name", $image)->delete();
        //return $imageData;
        return back();
    }

    public function storeServiceImage(Request $request, $id)
    {
        $service=Service::find($id);
        $request->validate([
            'service_image' => 'bail:required|image|mimes:jpeg,png'
        ]);
        if ($request->service_image) {
            $image_name = time() . "_" . $request->service_image->getClientOriginalName();
            $filePath = 'dashboardImages/service/'.$image_name;
            $request->service_image->move("dashboardImages/service", $image_name);
            $image=Image::create(['name' => $image_name,'path'=>$filePath,'alt'=>$service->service_en->title]);
            $image_id=array();
            array_push($image_id,$image->id);
            $service->images()->attach($image_id);
            return back();
        }
        //dd($request->file('product_im'));

    }

    public function storeServiceImages(Request $request, $id)
    {
        $service=Service::find($id);
        $request->validate([
            'service_image.*' => 'bail:required|image|mimes:jpeg,png'
        ]);
        if ($uploadFiles=$request->service_image) {
            $images_ids=array();
            foreach ($uploadFiles as $uploadFile){
                $image_name = time() . "_" .$uploadFile->getClientOriginalName();
                $filePath = 'dashboardImages/service/'.$image_name;
                $uploadFile->move("dashboardImages/service", $image_name);
                $image=Image::create(['name' => $image_name,'path'=>$filePath,'alt'=>$service->service_en->title]);
                array_push($images_ids,$image->id);
            }
            $service->images()->attach($images_ids);

            return back();
        }
        //dd($request->file('product_im'));

    }
}
