<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model{
    use SoftDeletes;
    protected $connection='mysql';
    protected $table='branch';
    protected $fillable=['phone','phone_alt','location','created_by'];
    protected $dates=["deleted_at"];

    public function branch_ar(){
        return $this->hasOne("App\Models\Arabic\Branch",'branch_id','id');
    }
    public function branch_en(){
        return $this->hasOne("App\Models\English\Branch",'branch_id','id');
    }

    public function working_days(){
        return $this->hasOne("App\Models\Working_days","branch_id",'id');
    }
    public function createdBy(){
        return $this->hasOne('App\User','id','created_by');
    }
}
