<?php

namespace App\Providers;

use App\Http\ViewComposers\LayoutsComposer;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class LayoutsServiceProvide extends ServiceProvider
{
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer(
            [
                'website.welcome',
                'website.about',
                'website.bio',
                'website.contact',
                'website.blog',
                'website.blogDetails',
                'website.service',
                'website.serviceDetails',
                'website.reserve',
                'website.offers',
                'website.album',
                'website.albumDetails',
                'website.video',
                'website.gallery',
                'website.team',
                'website.success_story',
                'website.all_success_story',
                'website.medical_tourism',
                'website.all_medical_tourism',
                'website.questions',
            ],
            LayoutsComposer::class
        );
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
