<?php

class About extends Controller
{

    public function edit()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        //start edit Data
        if (isset($_POST['edit'])) {

            // preparing validation array
            $validationArray = array(


                "description" => array(
                    "value" => addslashes($_POST['description']),
                    "errorName" => "ِAbout us Description",
                    "rules" => "required"
                ),

                "status" => array(
                    "value" => $this->loadSecurity($_POST['status'])->clear(),
                    "errorName" => "Status",
                    "rules" => "number"
                ),
            );
            // load validation classs and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                // prepare data model
                $dataModel['description'] = $dataValid['success']['description'];
                $dataModel['created_by'] = $user_id;
                $dataModel['last_update_by'] = $user_id;
                $dataModel['status'] = $dataValid['success']['status'];
                $dataModel['createdAt'] = date('Y-m-d h:i:s');
                // edit news
                $edit = $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1);
                if (FALSE !== $edit) {
                    $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
                    header("Refresh: 2");
                } else {
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data</div>';
                }

            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
            }
        }
        // get data
        $dataView['abouts'] = $this->loadModel("AboutusModel")->retrieveAllData();
        if ($dataView['abouts'] == NULL) {
            $this->redirect("error", "index");
            exit();
        }
        $dataView['abouts'] = array_shift($dataView['abouts']);
        // set page title
        $dataView['title'] = "Edit  About Us Page";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "aboutus_page_edit";          // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function update_image()
    {
        $upload = $this->loadUpload("image_name")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['image'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("AboutusModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }

}

?>
