<?php



/**

 * Controller class 

 *

 * this class contain the methods that deals with other classes in the system 

 * like model class ,template class 

 *

 * LICENSE: Open source

 *

 * @category   general

 * @package    core system

 * @subpackage parent

 * @copyright  coderg

 * @license    http://coderg.com

 * @version    .01

 * @link       http://coderg.com

 * @since      2018

 */

class Controller {



    /**

     * LoadModel

     *  

     * get an object from the needed model from the model folder

     *

     * @param  $name  (string) model name 

     * @param  $data(optional)  (array)  data to be added or updated 

     * @return   (object) object from the model  

     *

     */

    public function loadModel($name, $data = '') {

        $model = new $name($data);

        return $model;

    }



    

    /**

     * loadTemplate

     *

     * get object from the Template class that used to render the page contents

     *

     * @param  $templateArray  (array)  array of page content like ; array(PATH.'header',PATH.'content',PATH.'footer');

     * @param  $pageVars(optional) (array)  array of data that will be used in the view

     * @return   (object) object from the FrontEndTemplate class

     *

     */

    public function loadTemplate($templateArray, $pageVars = '') {

        $template = new Template($templateArray, $pageVars);

        return $template;

    }

    public function loadTemplate2($templateArray, $pageVars = '') {

        $template = new Template2($templateArray, $pageVars);

        return $template;

    }

    /**

     * validate 

     *  

     * get object from the validation class that used to validate many type of data  

     *

     * @param  $data  (unknown_type)  data that need to be validated       

     * @return   (object) object from the validation class

     *

     */

    public function loadValidation($data,$continue_on_error = FALSE) {

        

        $validation = new Validation($data,$continue_on_error);

        return $validation;

    }



    /**

     * uploadFile 

     *  

     * get object from the upload class that used to upload files

     *

     * @param  $input  (string) form input name

     * @return   (object) object from the upload class

     *

     */

    public function loadUpload($input,$required = TRUE) {

        

        $upload = new Upload($input,$required);

        return $upload;

    }

    /**

     * session

     *

     * get object from the session class

     *

     * @param  $sessions  (array) array of seesion ;like array('username'=>'ahmed','password'=>'222');

     * @return   (object) object from the Session class

     *

     */

    public function loadSession($sessions = "") {

        $session = new Session($sessions);

        return $session;

    }

    /**

     * UseAjax

     *

     * get object from the ajax class

     *

     * @return   (object) object from the Ajax class

     *

     */



    public function loadAjax() {

        $ajax = new Ajax();

        return $ajax;

    }

    /**

     * pagination

     *

     * get object from the pagination class

     *

     * @param    (none) 

     * @return   (object) object from the pagination class

     *

     */



    public function loadPagination()

    {

        $pagination = new Pagination();

        return $pagination;

    }

    

    /**

     * redirect

     *

     * redirect to a specific controller and method

     *

     * @param   

     * @return   none

     *

     */

    public function redirect($controller, $action, $message="")

    {

        if($message == null){

            header("Location:".BASE_URL.$controller."/".$action);

            exit();

        }else{

            header("Location:".BASE_URL.$controller."/".$action."/".$message);

            exit();

        }

    }

    

    /**

     * loadSecurity

     *

     * get object from the Security

     *

     * @param  $data (unknown) 

     * @return   (object) object from the Security class

     *

     */

    public function loadSecurity($data)

    {

        

        $security = new Security($data);

        return $security;

    }

    

    /**

     * LoadRoute

     *

     * get an object from the Route class 

     *

     * @param  (none)

     *  @return   (object) object from the Route class

     */

    public function loadRoute() {

        $route = new Route();

        return $route;

    }

    /**

     * loadCurl

     *

     * get an object from the Curl class 

     *

     * @param  (none)

     *  @return   (object) object from the Curl class

     */

    public function loadCurl() {

        $curl = new Curl();

        return $curl;

    }

    /**

     * loadHelper

     *

     * get an object from specific helper class 

     *

     * @param  (none)

     *  @return   (object) object from specific helper class

     */

    public function loadHelper($helper_name,$params="") {

        $helper = new $helper_name($params);

        return $helper;

    }

	/**

     * excel writer

     *

     * get object from the excel writer class

     *

     * @param  $file  file name of excel file to be created.

     * @return   (object) object from the ExcelWriter class

     *

     */

    public function loadExcelWriter($file = "") {

        $excel = new ExcelWriter($file);

        return $excel;

    }



}

