<?PHP





/**


 * Route class


 *


 * this class contain the methods that deals with url and routing


 *


 *


 * LICENSE: Open source


 *


 * @category   general


 * @package    core system


 * @subpackage parent


 * @copyright  coderg


 * @license    http://coderg.com


 * @version    .01


 * @link       http://coderg.com


 * @since      2018


 */


class Route {





    //controller name


    private $controller;


    //action name


    private $action;


    //parameters 


    private $parameters = [];


    //parsed url array


    private $urlArray = [];





    /**


     *  __construct


     *


     * contructor


     * @param    none


     * @return   none


     *


     */


    public function __construct() {


        //run parseUrl 


        $this->parseUrl();


        //set controller 


        $this->setController();


        //set action 


        $this->setAction();


        //set parameters 


        $this->setParameters();


        //check controller 


        $this->checkController();


        //check action 


        $this->checkAction();


    }





    /**


     *  runParser


     *


     * redirect the view to the controller and the action


     * @param    none


     * @return   none


     *


     */


    public function runParser() {


        //take object from the controller 


        $obj = new $this->controller;


		// set time zone (get time zone from templete config) if not found set it to (Africa/Cairo) 


		global $routeConfig;


		if(isset($routeConfig['default_time_zone']))


		{


			date_default_timezone_set($routeConfig['default_time_zone']);


		}else{


			date_default_timezone_set("Africa/Cairo");


		}


        //call the action 


        call_user_func(array($obj, $this->action));


    }





    /**


     *  parseUrl


     *


     * parse url to url array


     * @param    none


     * @return   none


     *


     */


    private function parseUrl() {


        if (isset($_GET['url'])) {


            $this->urlArray = explode('/', filter_var(rtrim($_GET['url'], '/')), FILTER_SANITIZE_URL);


			global $routeConfig;


              if ($this->urlArray[0] == 'index.php') 


			  {


				  $this->urlArray[0] = $routeConfig['default_controller'];


				  $this->urlArray[1] = $routeConfig['default_action'];


              }else if($this->checkAdminPath() && (count($this->urlArray) == 1)){


				  


				  $this->urlArray[1] = $routeConfig['admin_default_controller'];


				  $this->urlArray[2] = $routeConfig['admin_default_action'];


			  }


        }


    }





    /**


     *  setController


     *


     * set the controller from the url array


     * @param    none


     * @return   none


     *


     */


    private function setController() {


        global $routeConfig;


        if (!array_key_exists(0, $this->urlArray)) {


            $this->controller = $routeConfig['error_controller'];


        } else {


            if($this->checkAdminPath())


            {


              $this->controller = strtolower($this->urlArray[1]);  


            }else{


               $this->controller = strtolower($this->urlArray[0]); 


            }


        }


    }





    /**


     *   setAction


     *


     * set the action from the url array


     * @param    none


     * @return   none


     *


     */


    private function setAction() {


        global $routeConfig;


        if (array_key_exists(1, $this->urlArray)) 


        {   


            if($this->checkAdminPath())


            {


                $this->action = $this->urlArray[2];


                $this->action=str_replace('-', "_", $this->action);


            }else{


                $this->action = $this->urlArray[1];


                $this->action=str_replace('-', "_", $this->action);


            }


        }else{


            $this->action = "index";


            $this->action=str_replace('-', "_", $this->action);


        }


    }





    /**


     *  setParameters


     *


     * set the paramaters from the url array


     * @param    none


     * @return   none


     *


     */


    private function setParameters() {


        if($this->checkAdminPath())


        {


            if (!array_key_exists(3, $this->urlArray)) 


            {


                return;


            } else {


                $this->parameters = array_slice($this->urlArray, 3);


            }


        }else{


            if (!array_key_exists(2, $this->urlArray)) 


            {


                return;


            } else {


                $this->parameters = array_slice($this->urlArray, 2);


            }


        }  


    }





    /**


     * getController


     *


     * get the controller name 


     * @param    none


     * @return   string


     *


     */


    public function getController() {


        return $this->controller;


    }





    /**


     *  getAction


     *


     * get the action 


     * @param    none


     * @return   string


     *


     */


    public function getAction() {


        return $this->action;


    }





    /**


     *  getParameters


     *


     * get parameters array


     * @param    none


     * @return   array


     *


     */


    public function getParameters() {


        


        return $this->parameters; 


    }





    /**


     *  checkController


     *


     * check if controller exists or not  


     * @param    none


     * @return   none


     *


     */


    private function checkController() {


        //$path = CONTROLLER_PATH . strtolower($this->controller) . '.php';


        //check if the controller exists and require once it ,else go to the error controller 


        global $routeConfig;


        if ($this->checkAdminPath())


        {


            $path = CONTROLLER_PATH . $routeConfig['adminPath']."/". strtolower($this->controller) . '.php';


        }else{


            $path = CONTROLLER_PATH . strtolower($this->controller) . '.php';


        }


        if (!file_exists($path)) {


            //set the controller the error_controller


            $this->controller = $routeConfig['error_controller'];


            $this->action=$routeConfig['default_error_action'];


            header('Location:' . BASE_URL . $this->controller . '/' . $this->action);


            exit();


        }


    }





    /**


     *  checkAction


     *


     * check if the action exists in the controller 


     * @param    none


     * @return   none


     *


     */


    private function checkAction() {


        //check if the method exists in the controller or not 


        if (!method_exists($this->controller, $this->action)) {


            global $routeConfig;


            //set the action to the default_error_action


            $this->controller = $routeConfig['error_controller'];


            $this->action = $routeConfig['default_error_action'];


            header('Location:' . BASE_URL . $this->controller . '/' . $this->action);


            exit();


        }


    }





    /**


     *  getSegment


     *


     * get a segment from the url


     * @param    $index (int) segment order


     * @return   none


     *


     */


    public function getSegment($index) {


        //check if the segment key exists in the url array


        if (!array_key_exists($index, $this->urlArray)) {


            //return false if is not in the array


            return false;


        }


        //return the value of the segment 


        return $this->urlArray[$index];


    }


    


    public function getLastSegment(){


        return end($this->urlArray);


    }


    


    public function checkAdminPath()


    {


        global $routeConfig;


        return ($this->urlArray[0] == $routeConfig['adminPath']) ? TRUE:FALSE;


    }





}


