@extends('dashboard.layouts.layouts')
@section('title', 'Dashboard')
{{--Drop Your Customized Style Codes Here--}}
@section('customizedStyle')

@endsection
{{--Drop Your Customized Scripts Codes Here--}}
@section('customizedScript')
    <script>
        $(function () {
            $('#example1').DataTable()
            $('#example2').DataTable({
                'paging'      : true,
                'lengthChange': false,
                'searching'   : false,
                'ordering'    : true,
                'info'        : true,
                'autoWidth'   : false
            })
        })
    </script>
@endsection
{{-- Start of page Content --}}
@section('content')

    <section class="content-header">
        <h1>
            Branchs
            <small>All Branchs</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl("/")}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl("branch")}}">Branch</a></li>
            <li class="active">All Branchs</li>
        </ol>
    </section>


    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All Branchs Info</h3>
                        <a href="{{adminUrl("branch/create")}}" class="btn btn-warning pull-right"><i class="fa fa-plus"></i> Add New Branch </a>
                    </div>
                @include('dashboard.layouts.messages')
                <!-- /.box-header -->
                    <!-- form start -->
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>id</th>
                            <th>name</th>
                            <th>phone</th>
                            <th>address</th>
                            <th>created by</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tfoot>
                        <tr>
                            <th>id</th>
                            <th>name</th>
                            <th>phone</th>
                            <th>address</th>
                            <th>created by</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                        <tbody>
                            @if($branchs)
                                @foreach($branchs as $branch)
                                    <tr>
                                        <td>{{$branch->id}}</td>
                                        <td>{{$branch->branch_en->name}}</td>
                                        <td>{{$branch->phone}}</td>
                                        <td>{{$branch->branch_en->address}}</td>
                                        <td>{{$branch->createdBy->name}}</td>
                                        <td>{{$branch->created_at}}</td>
                                        <td>{{$branch->updated_at}}</td>
                                        <td>
                                            {{--<a href="/adminDashboard/branch/show/{{$branch->id}}" class="" style="font-size: 20px"><i class="fa fa-image"></i> </a>--}}
                                            <a href="{{route('branch.edit', $branch->id)}}" class="" style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                            <a type="button" class=""href="{{route('branch.destroy', $branch->id)}}" data-toggle="modal" data-target="#delete{{$branch->id}}" style="font-size: 20px">{{--{{$feature->id}}--}}
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            @else

                            @endif
                        </tbody>
                    </table>
                    @if($branchs)
                        @foreach($branchs as $branch)
                    <div class="modal modal-danger fade" id="delete{{$branch->id}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title">Delete Branch</h4>
                                </div>
                                <div class="modal-body">
                                    <p>Are You Sure You Want To Delete Feature <strong>{{$branch->id}}</strong></p>
                                </div>
                                <div class="modal-footer">
                                    <form action="{{route('branch.destroy', $branch->id)}}" method="post">
                                        @method('delete')
                                        @csrf
                                        <div class="d-flex flex-row">
                                            <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                cancel
                                            </button>
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                        @endforeach
                    @else

                    @endif
                </div>
            </div>
        </div>
    </section>

@endsection
