@extends('dashboard.layouts.layouts')
@section('title', 'Dashboard')
{{--Drop Your Customized Style Codes Here--}}
@section('customizedStyle')
@endsection
{{--Drop Your Customized Scripts Codes Here--}}
@section('customizedScript')
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
@endsection
{{-- Start of page Content --}}
@section('content')

    <section class="content-header">
        <h1>
            FAQ
            <small>Update FAQ</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{adminUrl('faq')}}">FAQ</a></li>
            <li class="active">Update FAQ</li>
        </ol>
    </section>


    <section class="content">
        @include('dashboard.layouts.messages')
        <form role="form" action="{{route('faq.update', $faq->id)}}" enctype="multipart/form-data" method="post">
            @csrf
            @method('patch')
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add FAQ Info <strong>(En)</strong></h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> FAQ Question</label>
                                    <input type="text" class="form-control" name="question_en" id="exampleInputEmail1" placeholder="Enter FAQ Question" value="{{$faq->faq_en->question}}">
                                    <p class="help-block">Enter FAQ Question</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> FAQ Answer</label>
                                    <textarea class="form-control" name="answer_en" id="exampleInputEmail1" placeholder="Enter FAQ Answer">{{$faq->faq_en->answer}}</textarea>
                                    <p class="help-block">Enter FAQ Answer</p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- German Side -->
                {{--<div class="col-md-4">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add Specialization Info <strong>(De)</strong></h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> FAQ Question</label>
                                    <input type="text" class="form-control" name="question_de" id="exampleInputEmail1" placeholder="Enter FAQ Question" value="{{$faq->faq_de->question}}">
                                    <p class="help-block">Enter FAQ Question</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> FAQ Answer</label>
                                    <textarea class="form-control" name="answer_de" id="exampleInputEmail1" placeholder="Enter FAQ Answer">{{$faq->faq_de->answer}}</textarea>
                                    <p class="help-block">Enter FAQ Answer</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>--}}

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات التخصص</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> السؤال</label>
                                    <input type="text" class="form-control" name="question_ar" id="exampleInputEmail1" placeholder="اخل نص السؤال" value="{{$faq->faq_ar->question}}">
                                    <p class="help-block">اخل نص السؤال</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">الإجابة</label>
                                    <textarea class="form-control" name="answer_ar" id="exampleInputEmail1" placeholder="ادخل نص الإجابة">{{$faq->faq_ar->answer}}</textarea>
                                    <p class="help-block">ادخل نص الإجابة</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

@endsection
