@extends('website.layouts.layouts')
@section('title', __('trans.team'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')

    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--الالبوم--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url('/')}}">{{--الرئيسية--}}
                                        {{__("trans.home")}}
                                        </a></li>
                                    <li><a href="{{url("/album")}}">{{--البوم الصور--}}
                                            {{__("trans.gallery_page_title")}}
                                        </a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <div class="page-gallery" id="gallery">
        <div class="container">
            <div class="row">
                @if($albums)
                    @foreach($albums as $album)
                        <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                            <a class="thumbnail" href="{{url('/album/'.$album->id)}}">
                                <img class="" src="{{assetPath($album->image->path)}}" alt="Another alt text">
                                <h1>{{$album->{'album_'.currentLang()}->title}}</h1>
                            </a>
                        </div>
                    @endforeach
                @else

                @endif
                {{--<div class="col-lg-3 col-md-4 col-xs-6 thumb">
                    <a class="thumbnail" href="gallery.html">
                        <img class="" src="imgs/dr-about.JPG" alt="Another alt text">
                        <h1>مؤتمرات وجوائز</h1>

                    </a>
                </div>
                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                    <a class="thumbnail" href="gallery.html">
                        <img class="" src="imgs/about1.png" alt="Another alt text">
                        <h1>صور العيادات</h1>

                    </a>
                </div>
                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                    <a class="thumbnail" href="gallery.html">
                        <img class="" src="imgs/gallery/gallery-3.jpg" alt="Another alt text">
                        <h1>صور المستشفيات</h1>

                    </a>
                </div>
                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                    <a class="thumbnail" href="gallery.html">
                        <img class="" src="imgs/gallery/gallery-4.jpg" alt="Another alt text">
                        <h1>صور الحالات</h1>
                    </a>
                </div>
--}}



            </div>






        </div>



    </div>

    <!--============ End about_page ============-->


@endsection
