@extends('website.layouts.layouts')
@section('title', __('trans.team'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')

    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--الالبوم--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url('/')}}">{{--الرئيسية--}}
                                        {{__("trans.home")}}
                                        </a></li>
                                    <li><a href="{{url("/album")}}">{{--البوم الصور--}}
                                        {{__("trans.gallery_page_title")}}
                                        </a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <section class="gallery-section">
        <div class="container">
            <div class="sortable-masonry">
                <div class="items-container row">
                @if($imagesAlbum)
                    @foreach($imagesAlbum->images as $album_image)
                       {{-- <div class="items-container row">--}}
                            <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                                <div class="image-box">
                                    <a href="{{assetPath($album_image->path)}}" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="{{assetPath($album_image->path)}}" alt=""></figure>
                                        <div class="overlay-box">
                                            <div class="inner">
                                                <span class="fas fa-search" style="color: #de74cc"></span>

                                            </div>
                                        </div> </a>
                                </div>
                            </div>
                       {{-- </div>--}}
                    @endforeach
                @else
                @endif
                </div>
                {{--<div class="items-container row">
                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-1.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-1.jpg" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>

                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-2.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-2.jpg" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-3.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-3.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-4.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-4.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-5.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-5.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-4 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-6.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-6.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                </div>--}}
            </div>
            <ul class="shop-pagination box-shadow text-center ptblr-10-30">
                        <li><a href="#"><i class="fas fa-chevron-right"></i></a></li>
                        <li class="active"><a href="#">01</a></li>
                        <li><a href="#">02</a></li>
                        <li><a href="#">03</a></li>
                        <li><a href="#">04</a></li>
                        <li><a href="#"><i class="fas fa-chevron-left"></i></a></li>

            </ul>
        </div>
    </section>

    <!--============ End about_page ============-->


@endsection
