@extends('website.layouts.layouts')
@section('title', __('trans.success_stories'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url("/")}}">{{--الرئيسية--}}{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/success-story")}}"> {{--السياحة العلاجية--}}{{__("trans.success_stories")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <div class="services">
        <div class="container">
            <h3 class="title"> {{__("trans.success_stories")}}</h3>

            <div class="row">
                <!--Start row-->
                @if($services)
                    @foreach($services as $mainService)
                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="single_service">
                                <a href="{{url("/success-story/".$mainService->url)}}" class="wow zoomIn" data-wow-duration="1.5s">
                                    <img src="{{assetPath($mainService->image->path)}}" alt="{{$mainService->image->alt}}">
                                    <div class="heading_service">
                                        <h3 class="front">{{$mainService->{'service_'.currentLang()}->title}}</h3>
                                        <h3 class="back">{{$mainService->{'service_'.currentLang()}->title}}</h3>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/white-3.jpg")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تكميم المعدة</h3>
                                    <h3 class="back">تكميم المعدة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/white-2.jpg")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">بالون المعدة</h3>
                                    <h3 class="back">بالون المعدة</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/white-4.jpg")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">جراحات الاعادة</h3>
                                    <h3 class="back">جراحات الاعادة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/whiteSmile.png")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">برنامج تغذية</h3>
                                    <h3 class="back">برنامج تغذية</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/white-3.jpg")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">علاج اضطرابات الغدد</h3>
                                    <h3 class="back">علاج اضطرابات الغدد</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="{{assetPath("website/imgs/services/people-2597995_640.jpg")}}" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تجميل بعد التخسيس</h3>
                                    <h3 class="back">تجميل بعد التخسيس</h3>
                                </div>
                            </a>
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>


@endsection
