@extends('website.layouts.layouts')
@section('title', __('trans.patient_info'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $blog->{'blog_' . currentLang()}->title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url('blog/' . $og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $blog->{'blog_' . currentLang()}->body}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url('blog/' . $og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--الالبوم--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url("/")}}">{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/blog/".$blog->url)}}">{{__("trans.blog_details")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= start blog_area =============-->
    {{--<div class="blog_area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="blog_detaisl_area">
                        <div class="blog_full_content">
                            <img src="{{assetPath($blog->image->path)}}" alt="">
                            <h4> {{$blog->{'blog_'.currentLang()}->title}} </h4>

                            <p>{!!  $blog->{'blog_'.currentLang()}->description !!}</p>
                        </div>


                    </div>
                </div>
                <div class="col-lg-12 col-md-12">
                    <div class="widget_raper">
                        <h4>مقالات ذات صلة</h4>

                        <div class="recent_post">
                            <div class="row">

                                <div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-1.jpg);"></span>
                                        <h4> تجميل وعلاج الأسنان بالفينير </h4>
                                        <span>October 27, 2017</span>
                                    </a>
                                </div>
                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-2.jpg);"></span>
                                        <h4> اسعار ابتسامة هوليود وكم جلسة </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-3.jpg);"></span>
                                        <h4>كيفيفة الحفاظ على الاسنان من التسوس</h4>
                                        <span>October 27, 2017</span>
                                    </a>                                        </div>

                                <div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">

                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-4.jpg);"></span>
                                        <h4> تجميل وعلاج الأسنان بالفينير </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-5.jpg);"></span>
                                        <h4> اسعار ابتسامة هوليود وكم جلسة </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-6.jpg);"></span>
                                        <h4>كيفيفة الحفاظ على الاسنان من التسوس</h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>--}}
    <div class="blog_area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="blog_detaisl_area">
                        <div class="blog_full_content">
                            <img src="{{assetPath($blog->image->path)}}" alt="">
                            <h4> {{$blog->{'blog_'.currentLang()}->title}} </h4>
                            {!!  $blog->{'blog_'.currentLang()}->body !!}
                        </div>


                    </div>
                </div>
                <div class="col-lg-12 col-md-12">
                    <div class="widget_raper">
                        <h4>{{--مقالات ذات صلة--}}{{__("trans.related_articles")}}</h4>

                        <div class="recent_post">
                            <div class="row">
                                @if($latestPosts)
                                    @foreach($latestPosts as $latestPost)
                                        <div class="col-lg-4 col-md-6">
                                            <a href="{{url("/blog/".$latestPost->url)}}" class="single_recent_post">
                                                <img class="rp_img" src="{{asset($latestPost->image->path)}}">
                                                <h4> {{$latestPost->{'blog_'.currentLang()}->title}} </h4>
                                                <span>{{$latestPost->created_at}}</span>
                                            </a>
                                        </div>
                                    @endforeach
                                @endif
                                {{--<div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-1.jpg);"></span>
                                        <h4> تجميل وعلاج الأسنان بالفينير </h4>
                                        <span>October 27, 2017</span>
                                    </a>
                                </div>
                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-2.jpg);"></span>
                                        <h4> اسعار ابتسامة هوليود وكم جلسة </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-3.jpg);"></span>
                                        <h4>كيفيفة الحفاظ على الاسنان من التسوس</h4>
                                        <span>October 27, 2017</span>
                                    </a>                                        </div>

                                <div class="col-lg-4 col-md-6">
                                    <a href="#" class="single_recent_post">

                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-4.jpg);"></span>
                                        <h4> تجميل وعلاج الأسنان بالفينير </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-5.jpg);"></span>
                                        <h4> اسعار ابتسامة هوليود وكم جلسة </h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>

                                <div class="col-lg-4 col-md-6">

                                    <a href="#" class="single_recent_post">
                                        <span class="rp_img" style="background-image: url(imgs/gallery/gallery-6.jpg);"></span>
                                        <h4>كيفيفة الحفاظ على الاسنان من التسوس</h4>
                                        <span>October 27, 2017</span>
                                    </a>                                    </div>--}}

                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <!--============= End blog_area =============-->


@endsection
