@extends('website.layouts.layouts')
@section('title', __('trans.common_questions'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')

    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url("/")}}">{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/questions")}}">{{__("trans.faq")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->

    <!--============= Start FAq =============-->
    <section class="faq-content-area">
        <div class="container">
            <div class="row">

                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="single-box">
                        <div class="sec-title mar0auto text-center">
                            <h1>اهم الاسئلة الشائعة</h1>
                            <span class="border"></span>
                        </div>
                        <div class="accordion-box">
                             @if($faqs)
                                @foreach($faqs as $faq)
                                    <div class="accordion accordion-block">
                                        <div class="accord-btn {{$loop->first ? 'active' :''}}">
                                            <h4>{{$faq->{'faq_'.currentLang()}->question }}</h4>
                                        </div>
                                        <div class="accord-content" style="{{$loop->first ? 'display: block;' :'display: none;'}}">
                                            <p>{{$faq->{'faq_'.currentLang()}->answer }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                            {{---<!--Start single accordion box-->
                            <div class="accordion accordion-block">
                                <div class="accord-btn active">
                                    <h4>ماذا يقول عملائنا ؟</h4>
                                </div>
                                <div class="accord-content" style="display: block;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>
                                </div>
                            </div>
                            <!--End single accordion box-->
                            <!--Start single accordion box-->
                            <div class="accordion accordion-block">
                                <div class="accord-btn">
                                    <h4>ما مقدار الوزن الذي يسيتم خسارته؟</h4>
                                </div>
                                <div class="accord-content collapsed" style="display: none;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>

                                </div>
                            </div>
                            <!--End single accordion box-->
                            <!--Start single accordion box-->
                            <div class="accordion accordion-block">
                                <div class ="accord-btn">
                                    <h4> هي الاختبارات اللازمة قبل الجراحة ؟</h4>
                                </div>
                                <div class="accord-content" style="display: none;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>

                                </div>
                            </div>
                            <!--End single accordion box-->
                            <!--Start single accordion box-->
                            <div class="accordion accordion-block">
                                <div class="accord-btn">
                                    <h4>هل يعاني مرضى عمليات إنقاص الوزن من آلم مستمر؟</h4>
                                </div>
                                <div class="accord-content" style="display: none;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>

                                </div>
                            </div>
                            <div class="accordion accordion-block">
                                <div class="accord-btn">
                                    <h4>كم عدد الفتحات الجراحية التي ستتم في المعدة؟</h4>
                                </div>
                                <div class="accord-content" style="display: none;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>

                                </div>
                            </div>
                            <div class="accordion accordion-block">
                                <div class="accord-btn">
                                    <h4>كيف يشعر المريض عندما يستيقظ في غرفة الإفاقة؟</h4>
                                </div>
                                <div class="accord-content" style="display: none;">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>

                                </div>
                            </div>
                            <div class="accordion accordion-block">
                                <div class="accord-btn">
                                    <h4>متى يكون قادراً على قيادة السيارة؟</h4>
                                </div>
                                <div class="accord-content" style="">
                                    <p>أولاً وقبل كل شيء ، عليك التأكد من أن المظهر يطابق الشكل والشعور الذي تريده وتحتاج إليه. اعتدت أن أظن أنه بإمكانك تحويل سمة مميزة إلى ما تريد بمجرد التغيير والتبديل. لقد أدركت أن الأمر ليس بهذه السهولة..</p>
                                </div>
                            </div>
                            <!--End single accordion box-->---}}
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>
    <!--============= End FAq =============-->

@endsection
