@extends('website.layouts.layouts')
@section('title', __('trans.reserve'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <section class="breadcrumb-area" style="background-image: url({{assetPath('website/en/images/cover.jpg')}});">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="breadcrumbs">
                        <h1>{{ __('trans.reserve')}} </h1>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="left pull-left">
                            <ul>
                                <li><a href="index.html">{{ __('trans.home')}}</a></li>
                                <li><i class="fa fa-angle-right" aria-hidden="true"></i></li>
                                <li class="active"> {{ __('trans.reserve')}}</li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- banner -->

    <!-- about -->
    <div class="banner-bottom" id="about">
        <div class="container">
            <h2 class="dr_heade_tittle_main">{{ __('trans.reserve')}}</h2>
            <div class="book-appointment">
                <h4>{{ __('trans.add_your_info')}}</h4>
                @include('dashboard.layouts.messages')
                <form action="{{url('reserve')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="left-main same">
                        <div class="gaps">
                            <p>{{__('trans.patient_name')}} </p>
                            <input type="text" name="name" placeholder="" required="" value="{{old('name')}}"/>
                        </div>
                        <div class="gaps">
                            <p>{{__('trans.form_phone')}} </p>
                            <input type="text" name="phone" placeholder="" required="" value="{{old('phone')}}"/>
                        </div>
                        <div class="gaps">
                            <p>{{__('trans.email')}}</p>
                            <input type="email" name="email" placeholder="" required="" value="{{old('email')}}" />
                        </div>
                        <div class="gaps">
                            <p>{{__('trans.message')}}</p>
                            <textarea name="message" placeholder="" required=""  >{{old('message')}}</textarea>
                        </div>
                    </div>
                    <div class="right-maininfo same">
                        <div class="gaps">
                            <p>{{__('trans.birth_date')}}</p>
                            <input value="{{old('birth_date')}}"  id="datepicker1" name="birth_date" type="date" onfocus="this.value = '';" onblur="if (this.value == '') {this.value = 'شهر/يوم/سنة';}" required="">
                        </div>

                        <div class="gaps">
                            <p>{{__('trans.choose_service')}}</p>
                            <select class="option" name="service_id">
                                <option value="">{{__('trans.choose_service')}}</option>
                                @if($mainServices)
                                    @foreach($mainServices as $mainService)
                                        <option value="{{$mainService->id}}">{{$mainService->{'service_'.currentLang()}->title }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="gaps">
                            <p>{{__('trans.gender')}}</p>
                            <select class="option" name="gender">
                                <option></option>
                                <option value="1">{{__('trans.child')}}</option>
                                <option value="2">{{__('trans.male')}}</option>
                                <option value="3">{{__('trans.female')}}</option>
                            </select>
                        </div>
                        <div class="gaps">
                            <p>{{__('trans.file')}} </p>
                            <label for="file-upload" class="custom-file-upload">
   اختر الملف
</label>
<input id="file-upload" type="file"/>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <input type="submit" value="{{__('trans.confirm')}} ">
                </form>
            </div>

        </div>
    </div>
    <!-- //about -->

    <!-- testimonial -->
    <div class="testimonial">
        <div class="container">
            <h2 class="dr_heade_tittle_main">{{__('trans.testimonials_title')}}</h2>
            <div class='row'>
                <div class='col-md-offset-2 col-md-8'>
                    <div class="owl-carousel owl-testimonial owl-theme">
                        <!-- Bottom Carousel Indicators -->
                        <!--
                        <ol class="carousel-indicators">
                            <li data-target="#quote-carousel" data-slide-to="0" class="active"></li>
                            <li data-target="#quote-carousel" data-slide-to="1"></li>
                            <li data-target="#quote-carousel" data-slide-to="2"></li>
                        </ol>
-->
                        <!-- Carousel Slides / Quotes -->

                    @if($testimonials)
                        @foreach($testimonials as $testimonial)
                            <!-- Quote 1 -->
                                <div class="item">
                                    <blockquote>
                                        <div class="row">
                                            <div class="col-sm-3 text-center">
                                                <img class="img-circle" src="{{assetPath($testimonial->image->path)}}">
                                            </div>
                                            <div class="col-sm-9">
                                                <p>{{$testimonial->{'testimonial_'.currentLang()}->text }}</p>
                                                <small>{{$testimonial->{'testimonial_'.currentLang()}->username }}</small>
                                            </div>
                                        </div>
                                    </blockquote>
                                </div>
                                <!-- Quote 2 -->
                            @endforeach
                        @endif
                    </div>
                    <!-- Carousel Buttons Next/Prev -->
                    <a data-slide="prev" href="#quote-carousel" class="left carousel-control"><i class="fa fa-chevron-left"></i></a>
                    <a data-slide="next" href="#quote-carousel" class="right carousel-control"><i class="fa fa-chevron-right"></i></a>
                </div>
            </div>
        </div>
    </div>
    <!-- //testimonial -->

@endsection
