@extends('website.layouts.layouts')
@section('title', __('trans.team'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url("/")}}">{{--الرئيسية--}}{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/team")}}">{{--فريق العمل --}}{{__("trans.team")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start main_info =============-->
    <section class="main_info">
        <div class="container">

            <div class="row">
                <div class="col-md-8 col-sm-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1.5s">
                            {{--فريق عمل مركز دكتور محمد ابوزيد--}}
                            {{__("trans.dr_abouzeid_team")}}
                            <hr>
                        </h3>
                        {{--<p class="wow fadeInRight" data-wow-duration="2s">
                            بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
                        </p>--}}
                        {!! $about?str_limit($about->{'about_'.currentLang()}->value,600,'...') :'no data to show.' !!}
                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="img-box">
                        @if($about)
                            <img src="{{assetPath($about->aboutImage->path)}}" alt="" style="width: 100%">
                            @else
                            <img src="website/imgs/dr-about.JPG" alt="" style="width: 100%">
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= end main_info =============-->

    <!--============= Start cheif =============-->
    <section class="cheif">
        <div class="overlay">
            <div class="container">
                @if($members)
                    @foreach($members as $member)
                        <div class="block">
                            <div class="head">
                                <h3>{{$member->{'team_'.currentLang()}->job_title}}</h3>
                            </div>
                            <div class="row">

                                <div class="col-md-4 col-xs-12">
                                    <div class="img_body">
                                        <img src="{{assetPath($member->image->path)}}" alt="">
                                        <h3>{{$member->{'team_'.currentLang()}->name}}</h3>
                                        <ul class="list-unstyled list-inline">
                                            @if($contact->facebook)
                                                <li>
                                                    <a href="{{$contact->facebook}}"><i class="fa fa-facebook fa-fw"></i></a>
                                                </li>
                                            @endif
                                            @if($contact->twitter)
                                                <li>
                                                    <a href="{{$contact->twitter}}"><i class="fa fa-twitter fa-fw"></i></a>
                                                </li>
                                            @endif
                                            @if($contact->youtube)
                                                <li>
                                                    <a href="{{$contact->youtube}}"><i class="fa fa-youtube fa-fw"></i></a>
                                                </li>
                                            @endif
                                            @if($contact->instagram)
                                                <li>
                                                    <a href="{{$contact->instagram}}"><i class="fa fa-instagram fa-fw"></i></a>
                                                </li>
                                            @endif
                                            @if($contact->snapchat)
                                                <li>
                                                    <a href="{{$contact->snapchat}}"><i class="fab fa-snapchat-ghost"></i></a>
                                                </li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>


                                <div class="col-md-8 col-xs-12">
                                    <!--<p>
                                        {{$member->{'team_'.currentLang()}->description}}
                                    </p>-->
                                     {!! $member->{'team_'.currentLang()}->description !!}
                                </div>

                            </div>
                        </div>
                    @endforeach
                @else

                @endif
                {{--<div class="block">
                    <div class="head">
                        <h3>كبير الاطباء</h3>
                    </div>
                    <div class="row">

                        <div class="col-md-4 col-xs-12">
                            <div class="img_body">
                                <img src="imgs/team/about1.png" alt="">
                                <h3>د/ محمد ابوزيد</h3>
                                <ul class="list-unstyled list-inline">
                                    <li>
                                        <a href=""><i class="fa fa-facebook fa-fw"></i></a>
                                    </li>
                                    <li>
                                        <a href=""><i class="fa fa-twitter fa-fw"></i></a>
                                    </li>
                                    <li>
                                        <a href="" ><i class="fa fa-youtube fa-fw"></i></a>
                                    </li>
                                    <li>
                                        <a href="" ><i class="fa fa-instagram fa-fw"></i></a>
                                    </li>
                                    <li>
                                        <a href=""><i class="fab fa-snapchat-ghost" aria-hidden="true"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>


                        <div class="col-md-8 col-xs-12">
                            <p>
                                بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
                            </p>
                        </div>

                    </div>
                </div>--}}
            </div>
        </div>
    </section>
    <!--============= End cheif =============-->
    <!--============= Start contact_bar =============-->
    <section class="contact_bar">
        <div class="overlay">
            <div class="container">
                <h3>{{--اكثر من 20 الف حالة تجميل ناجحة خلال عشرين عاما من الخبرة --}}{{__("trans.page_end_description")}}</h3>
            </div>
        </div>
    </section>
    <!--============= End contact_bar =============-->


@endsection
