@extends('website.layouts.layouts')
@section('title', __('trans.home'))

@section('open-graph')
    <meta name="description" content="{{$og->description}}">
    <meta name="keywords" content="{{$og->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url('/')}}"/>
    <meta property="og:image" content="{{$og->open_graph->image_url ? $og->open_graph->image_url : asset($og->open_graph->open_graph_image->path)}}"/>
    <meta property="og:description" content="{{$og->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('canonical')
   {{-- <link rel="canonical" href="{{url($og->url)}}"/>--}}
@endsection
@section('customizedScript')
    <script>
        $(".item:first-child").addClass("active");

    </script>
@endsection


@section('customizedStyle')
    <style>
       .slider__slide-part-inner{
            {{--@if($slides)
                @foreach($slides as $slide)
                     /*background-image:url('http://localhost:1000/website/imgs/slider/slide_3.png');*/
                      background-image:url({{assetPath($slide->image->path)}});
                @endforeach
            @endif--}}
        }
    </style>
@endsection


@section('content')
    <!--=============== Start particles ==============-->
    {{--<div class="Main">
        <div id="particles-js"></div>
    </div>--}}
    <!--=============== End particles ==============-->
    <!--============= Start swiper =============-->
  <div class="main-slider">

        <div class="swiper-container banner-carousel">
            <div class="Main">
                <div id="particles-js">
                    <canvas class="particles-js-canvas-el" width="1348" height="888" style="width: 100%; height: 100%;"></canvas>
                </div>
            </div>
            <div class="swiper-wrapper">
                @if($slides)
                    @foreach($slides as $slide)
                        <div class="swiper-slide slide">
                            <img src="{{assetPath($slide->image->path)}}" alt="">
                            <div class="auto-container">
                                <div class="content clearfix">
                                    <div class="title">{{$slide->{'slider_'.currentLang()}->title}}</div>
                                    <h2>{{$slide->{'slider_'.currentLang()}->description}}</h2>
                                    <div class="btn-box clearfix">
                                        <a href="{{$slide->url}}" class="theme-btn btn-style-two"><span class="txt">{{$slide->{'slider_'.currentLang()}->button}}</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif

            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
    <!--============= End swiper =============-->
    <!--============= Start me_slider =============-->
    {{--<div id="app1"></div>--}}
   {{-- @if($slides)
        @foreach($slides as $slide)
            <div class="sliders_hidden">
                <div class="sliders_hidden_images"data-id="{{$slide->image->path}}"></div>
            </div>
        @endforeach
    @else
    @endif--}}
    <!--============= End home_slider =============-->

    <!--============= Start services =============-->
    <section class="services" id="services">
        <div class="container">
            <!--Start Container-->
            <div class="heading">
                <h2>
                    {{--خدماتنا--}}
                    {{__("trans.services")}}
                    <img src="{{assetPath("website/imgs/services_line.png")}}" alt="services-line">
                </h2>
            </div>
            <div class="row">
                <!--Start row-->
                @if($mainServices)
                    @foreach($mainServices as $mainService)
                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="single_service">
                                <a href="{{url("/service/".$mainService->url)}}" class="wow zoomIn" data-wow-duration="1.5s">
                                    <img src="{{assetPath($mainService->image->path)}}" alt="{{$mainService->image->alt}}">
                                    <div class="heading_service">
                                        <h3 class="front">{{$mainService->{'service_'.currentLang()}->title}}</h3>
                                        <h3 class="back">{{$mainService->{'service_'.currentLang()}->title}}</h3>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/white-3.jpg" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تكميم المعدة</h3>
                                    <h3 class="back">تكميم المعدة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/white-2.jpg" alt="">
                                <div class="heading_service">
                                    <h3 class="front">بالون المعدة</h3>
                                    <h3 class="back">بالون المعدة</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/white-4.jpg" alt="">
                                <div class="heading_service">
                                    <h3 class="front">جراحات الاعادة</h3>
                                    <h3 class="back">جراحات الاعادة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/whiteSmile.png" alt="">
                                <div class="heading_service">
                                    <h3 class="front">برنامج تغذية</h3>
                                    <h3 class="back">برنامج تغذية</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/white-3.jpg" alt="">
                                <div class="heading_service">
                                    <h3 class="front">علاج اضطرابات الغدد</h3>
                                    <h3 class="back">علاج اضطرابات الغدد</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="imgs/services/people-2597995_640.jpg" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تجميل بعد التخسيس</h3>
                                    <h3 class="back">تجميل بعد التخسيس</h3>
                                </div>
                            </a>
                        </div>
                    </div>
                @endif

            </div>
            <!--End row-->
        </div>
        <!--End Container-->
    </section>
    <!--============= End services =============-->

    <!--============= Start video =============-->
    <section class="video">
        <div class="overlay">
            <!--Start overlay-->
            <div class="container">
                <!--Start Container-->
                <div class="row">
                    <!--Start row-->

                    {{--<div class="col-md-5 col-sm-6 col-xs-12">
                        <div class="vid wow fadeInLeft" data-wow-duration="1.5s">
                            <video controls id="myvideo">
                                --}}{{--<source src="http://thenewcode.com/assets/videos/atlantic-light.webm">--}}{{--
                                --}}{{--<source src="http://thenewcode.com/assets/videos/atlantic-light.mp4">--}}{{--
                            </video>
                            {{$about->video_url}}
                            <div class="ved_front">
                                <div class="layer">
                                    <i class="fa fa-play fa-fw"></i>
                                </div>
                            </div>
                        </div>
                    </div>--}}
                    <div class="col-md-5 col-sm-12">
                        <iframe width="100%" height="300" src="{{$about->video_url?$about->video_url:"https://www.youtube.com/embed/_Y6Ttq2l6zM--"}}{{--https://www.youtube.com/embed/_Y6Ttq2l6zM--}}" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                    <div class="col-md-7 col-sm-6 col-xs-12">
                        <div class="ved_info">
                            <h3 class="wow fadeInRight" data-wow-duration="1s"{{-->د.محمد ابوزيد--}}

                            </h3>
                            {{__("trans.about")}}
                            <p class="wow fadeInRight" data-wow-duration="1.5s">
{{--
                                هو أستاذ م جراحات المناظير والسمنة المفرطة بطب عين شمس، استشاري جراحات السمنه بالمنظار، زميل كليه الجراحين الملكيه بانجلترا ، عضو مجلس اداره الجمعيه المصريه لجراحات السمنه و الرابطه العربيه لجراحي السمنه. بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
--}}
                           {{--{!! $about->{'about_'.currentLang()}->description !!}--}}
                                {!! str_limit($about->{'about_'.currentLang()}->description ,300,'')  !!}
                            </p>
                            <a href="{{url("/team")}}" target="_blank" class=" wow fadeInRight" data-wow-duration="2s">{{--المزيد--}} {{__("trans.see_more")}}<i class="fa fa-angle-right fa-fw"></i></a>
                        </div>
                    </div>

                </div>
                <!--End row-->
            </div>
            <!--End Container-->
        </div>
        <!--End overlay-->
    </section>
    <!--============= End video =============-->
    <!--============= start appoint =============-->
    <div class="appoint-area">

        <div class="container">

            <div class="row">
                <div class="col-lg-6 col-md-6">

                    <div class="appointment position_none">
                        <div class="bar-hed text-right">
                            <h2 class=" text-center">{{-- احجز موعد--}}
                                {{__("trans.book_appointment")}}
                            </h2>

                        </div>

                        <div class="row">
                            <div class="contact">
                                <div class="col-lg-6 col-xs-6">
                                    <div class="call">

                                        <a href="tel:{{$contact->phone}}"> <i class="fas fa-phone"></i></a>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-xs-6">

                                    <div class="whats"><a href="https://wa.me/{{$contact->whatsapp}}"> <i class="fab fa-whatsapp"></i></a></div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="image-box">

                       {{-- <img src="{{assetPath("website/imgs/booking/about-2.jpg")}}" alt="">--}}
                        <img src="{{assetPath($about->aboutImage->path)}}" alt="">
                    </div>
                </div>


            </div>
        </div>
    </div>
    <!--============= End appoint =============-->

    <!--============= Start testi =============-->
    <section class="testi">
        <div class="container">
            <!--Start Container-->
            <div class="head text-center">
                <h2>
                    {{--اراء العملاء--}}
                    {{__("trans.testimonial")}}
                </h2>
                <p>

                </p>
                <img src="{{assetPath("website/imgs/testi/teeth.png")}}" alt="">
            </div>
            <div class="row">
                <!--Start row-->

                <div class="col-xs-12">
                    <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
                        <!-- Indicators -->

                        <!-- Controls -->
                        <div class="Controls-test">
                            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                                <span class="sr-only">Previous</span>
                            </a>
                            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                                <span class="sr-only">Next</span>
                            </a>
                        </div>
                        <!-- Wrapper for slides -->
                        <div class="carousel-inner" role="listbox">
                            @if($testimonials)
                                @foreach($testimonials as $testimonial)
                                    <div class="item  ">
                                        <div class="row">
                                            <div class="col-md-9 col-xs-12">
                                                <div class="testi_info">
                                                    <hr>
                                                    <h3>{{$testimonial->{'testimonial_'.currentLang()}->username}}</h3>
                                                    <p>
                                                        {{$testimonial->{'testimonial_'.currentLang()}->text}}</p>
                                                    <ul class="list-unstyled list-inline">
                                                        <li>
                                                            <i class="fa fa-star fa-fw"></i>
                                                            <i class="fa fa-star fa-fw"></i>
                                                            <i class="fa fa-star fa-fw"></i>
                                                            <i class="fa fa-star fa-fw"></i>
                                                            <i class="fa fa-star fa-fw"></i>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-xs-12">
                                                <div class="user">
                                                    <div class="bg">
                                                        <div class="bg_gray">
                                                            <img src="{{assetPath($testimonial->image->path)}}" alt=" ..">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="item active ">
                                    <div class="row">
                                        <div class="col-md-9 col-xs-12">
                                            <div class="testi_info">
                                                <hr>
                                                <h3>كارمن سليمان</h3>
                                                <p>
                                                    مركز دكتور نور الدين مصطفى لتجميل الاسنان افضل عيادة طب اسنان في مصر بل في الشرق الاوسط غيرت فكرتي عن مفهوم تجميل الاسنان و ألام الاسنان وصعوبتها، شكرا دكتور نور الدين على ابتسامة هوليود وشكرا فريقة الطبي.

                                                    كارمن سليمان </p>
                                                <ul class="list-unstyled list-inline">
                                                    <li>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="user">
                                                <div class="bg">
                                                    <div class="bg_gray">
                                                        <img src="imgs/testi/karmen.jpg" alt="كارمن سليمان">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="item  ">
                                    <div class="row">
                                        <div class="col-md-9 col-xs-12">
                                            <div class="testi_info">
                                                <hr>
                                                <h3>نذير العرباوى - سفير دولة الجزائر</h3>
                                                <p>
                                                    أشكر طبيب الاسنان نور الدين مصطفى وفريقة الطبي بالكامل وأتمنى له النجاح والتوفيق,
                                                    كما اود ان اشكره على حسن معاملته ودقته فى عمله.
                                                    نذير العرباوى - سفير دولة الجزائر </p>
                                                <ul class="list-unstyled list-inline">
                                                    <li>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                        <i class="fa fa-star fa-fw"></i>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-xs-12">
                                            <div class="user">
                                                <div class="bg">
                                                    <div class="bg_gray">
                                                        <img src="imgs/testi/karmen.jpg" alt="كارمن سليمان">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>

            </div>
            <!--End row-->
        </div>
        <!--End Container-->
    </section>
    <!--============= End testi =============-->
    <div class="blog_area">
        <div class="overlay">
            <div class="container">
                <div class="pattern-layer"></div>
                <div class="bar-hed text-center">
                    <h2 class=" text-center">{{--معلومات تهمك--}} {{__('trans.important_info')}} </h2>


                </div>
                <div class="row justify-content-center">
                    @if($blogs)
                        @foreach($blogs as $blog)
                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <a href="{{url("/blog/".$blog->url)}}"></a>
                                <div class="blog_box"><a href="{{url("/blog/".$blog->url)}}">
                                        <div class="blog_img"><img src="{{assetPath($blog->image->path)}}" alt=""></div>
                                    </a>
                                    <div class="blog_content"><a href="{{url("/blog/".$blog->url)}}">
                                        </a>
                                        <div class="blog_meta">
                                            <a href="{{url("/blog/".$blog->url)}}"></a>
                                           {{-- <a href="{{url("/blog/".$blog->url)}}" class="date">
                                                <h2>{{$blog->created_at->format("d")}}</h2>
                                                <span>{{$blog->created_at->format("M")}}</span>
                                            </a>--}}


                                        </div>
                                        <a href="{{url("/blog/".$blog->url)}}">
                                            <h4>{{$blog->{'blog_'.currentLang()}->title}}</h4>
                                            <p>{!!  strip_tags(str_limit($blog->{'blog_'.currentLang()}->body,'100','.'))!!}</p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                     @endif
                    {{--<div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="{{url("/blog")}}"></a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-1.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>28</h2>
                                        <span>اكتوبر</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>شكل جديد .. حياة سعيدة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html">
                        </a>
                        <div class="blog_box">
                            <a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-2.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>18</h2>
                                        <span>مارس</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>تأثير السمنة المفرطة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html"> </a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-3.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>17</h2>
                                        <span>فبراير</span>
                                    </a>

                                </div>

                                <a href="blog_details.html">
                                    <h4>حظر الدهون المتحولة يقلل من المخاطر الصحية</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>--}}

                </div>

            </div>
        </div>
    </div>
    <!--============= Start map =============-->
    <div class="map">
        {{--
        https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3453.065721257042!2d31.3601819848041!3d30.063650581875265!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14583ddfd9c88f4f%3A0xcb366bd0f4bc937e!2z2K3Ys9mGINmF2KPZhdmI2YbYjCDZhdiv2YrZhtipINmG2LXYsdiMINmF2K3Yp9mB2LjYqSDYp9mE2YLYp9mH2LHYqeKArA!5e0!3m2!1sar!2seg!4v1531237176958
        --}}
        <iframe src="{{$contact->location}}" width="" height="" frameborder="0" style="border:0" allowfullscreen></iframe>
    </div>
    <!--============= End map =============-->

@endsection
