<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
 <script src="<?php echo e(assetPath('dashboard/bower_components/ckeditor/ckeditor.js')); ?>"></script>
    <script>
         $(function () {
            // Replace the <textarea id="editor1"> with a CKEditor
            // instance, using default configuration.
            CKEDITOR.replace('editor1');
            CKEDITOR.replace('editor2');

            //bootstrap WYSIHTML5 - text editor
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <section class="content-header">
        <h1>
            Team
            <small>Update Member</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/team')); ?>">Team</a></li>
            <li class="active">Update Member</li>
        </ol>
    </section>


    <section class="content">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form role="form" action="<?php echo e(route('team.update', $member->id)); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add Member Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Name</label>
                                    <input type="text" class="form-control" name="name_en" id="exampleInputEmail1" placeholder="Enter Member Title" value="<?php echo e($member->team_en->name); ?>">
                                    <p class="help-block">Enter Name of Member</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Job Title</label>
                                    <input type="text" class="form-control" name="title_en" id="exampleInputEmail1" placeholder="Enter Member Title" value="<?php echo e($member->team_en->job_title); ?>">
                                    <p class="help-block">Enter Job Title</p>
                                </div>

                                

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Bio Description</label>
                                    <textarea  class="form-control" name="description_en" id="editor1" placeholder="Enter Member Bio" rows="6"><?php echo e($member->team_en->description); ?></textarea>
                                    <p class="help-block">Enter Member Bio</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input type="file" class="form-control" name="image_id" id="exampleInputEmail1" placeholder="Enter Member text">
                                    <p class="help-block"> Upload Member Image </p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Related Service Name</label>
                                    <select name="service_id" id="admin_type" class="form-control">
                                        <option value="0">Choose Service Name</option>
                                        <?php if($services): ?>
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($service->id); ?>" <?php echo e($service->id == $member->service_id ? 'selected' : ''); ?>><?php echo e($service->service_en->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="help-block"> Choose Service for this Member</p>
                                </div>

                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات العضو</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> إسم العضو</label>
                                    <input type="text" class="form-control" name="name_ar" id="exampleInputEmail1" placeholder="ادخل اسم العضو" value="<?php echo e($member->team_ar->name); ?>">
                                    <p class="help-block">ادخل اسم العضو</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">المسمى الوظيفي للعضو</label>
                                    <input type="text" class="form-control" name="title_ar" id="exampleInputEmail1" placeholder="ادخل المسمى الوظيفي للعضو" value="<?php echo e($member->team_ar->job_title); ?>">
                                    <p class="help-block">أضف المسمى الوظيفي للعضو</p>
                                </div>


                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">السيرة الذاتية</label>
                                    <textarea class="form-control" name="description_ar" id="editor2" placeholder="ادخل  السيرة الذاتية للعضو" rows="6" ><?php echo e($member->team_ar->description); ?></textarea>
                                    <p class="help-block">ادخل السيرة الذاتية للعضو</p>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>