<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Page
            <small>Update Page Info</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/website-main-pages')); ?>">Website Main Pages</a></li>
            <li class="active">Update Clinic</li>
        </ol>
    </section>


    <section class="content">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form role="form" action="<?php echo e(adminUrl('seo/website-page/edit/'.$page->id )); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>

            <div class="row">
                <!-- English Side -->
                <div class="col-md-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update <strong><?php echo e(strtoupper($page->name)); ?></strong> Page Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-6">
                                    <label for="exampleInputEmail1"> Page Name</label>
                                    <input type="text" class="form-control" name="name" id="exampleInputEmail1" placeholder="Enter Page Name" value="<?php echo e($page->name); ?>">
                                    <p class="help-block">Enter Page Name</p>
                                </div>

                                <div class="col-lg-6">
                                    <label for="exampleInputEmail1"> URL</label>
                                    <input type="text" class="form-control" name="url" disabled id="exampleInputEmail1" placeholder="Enter Clinic URL" value="<?php echo e($page->url); ?>">
                                    <p class="help-block">Url of Page on website</p>
                                </div>

                                <div class="col-lg-6 mt-5">
                                    <label for="exampleInputEmail1">Page Description</label>
                                    <textarea class="textarea" placeholder="Enter Page Description" name="description"
                                              style="width: 100%; resize: none; height: 100px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e(strip_tags($page->description)); ?></textarea>
                                    <p class="help-block">Enter Page Description if exist</p>
                                </div>

                                <div class="col-lg-6 mt-5">
                                    <label for="exampleInputEmail1">Page Keywords</label>
                                    <textarea class="textarea" placeholder="Enter Page keywords" name="keywords"
                                              style="width: 100%; resize: none; height: 100px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e($page->key_words); ?></textarea>
                                    <p class="help-block">Please Enter page key words if exist and put Comma(,) after every keyword </p>
                                </div>
                                <div class="col-lg-6 mt-5">
                                    <label for="exampleInputEmail1">Header Code</label>
                                    <textarea class="textarea" placeholder="Enter Page Header Customized Code" name="header_code"
                                              style="width: 100%; resize: none; height: 100px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e($page->header_code); ?></textarea>
                                    <p class="help-block">Put <strong>Javascript Code, Google Analytics Code, Google Tag Manager </strong>or any other codes in header of page </p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>