<?php $__env->startSection('title', __('trans.team')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url("/")); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/success-story")); ?>"><?php echo e(__("trans.success_stories")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <section class="main_info">
        <div class="container">
            <div class="row">



                <div class="col-md-7 col-sm-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1.5s">
                            <?php echo e(__("trans.dr_abouzeid_medical_tourism")); ?>

                            <hr>
                        </h3>
                        
                        <?php echo $about->{'about_'.currentLang()}->description; ?>

                    </div>
                </div>
                <div class="col-md-5 col-sm-12">
                    <iframe width="100%" height="300" src="<?php echo e($about->video_url?$about->video_url:"https://www.youtube.com/embed/_Y6Ttq2l6zM--"); ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>
    <!--============ End about_page ============-->
    <section class="gallery-section">
        <div class="container">

            <div class="sortable-masonry">



                <div class="items-container row">
                    <?php if($album): ?>
                        <?php $__currentLoopData = $album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                                <div class="image-box">
                                    <a href="<?php echo e(assetPath($album->path)); ?>" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="<?php echo e(assetPath($album->path)); ?>" alt=""></figure>
                                        <div class="overlay-box">
                                            <div class="inner">
                                                <span class="fas fa-search" style="color: #de74cc"></span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <?php endif; ?>
                    




                </div>
            </div>

        </div>
    </section>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>