<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-TTBMCRQ');</script>
<!-- End Google Tag Manager -->
    <?php echo $__env->yieldContent('open-graph'); ?>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1" />

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo __('trans.website_title'); ?> - <?php echo $__env->yieldContent('title'); ?></title>

    <!-- CSS ============================================ -->
    <!--=============== Bootstrap css ===============-->
    <link href="<?php echo e(asset("website/css/all.css")); ?>" rel="stylesheet">
    <link href="<?php echo e(asset("website/css/animate.css")); ?>" rel="stylesheet">

    <link href="<?php echo e(asset("website/css/bootstrap.min.css")); ?>" rel="stylesheet">
   
    <!--=============== fontAwesome css ===============-->
    <link href="<?php echo e(asset("website/css/font-awesome.min.css")); ?>" rel="stylesheet">
    <!--=============== google fonts css raleway pt ===============-->
    <link href="https://fonts.googleapis.com/css?family=PT+Sans|Raleway" rel="stylesheet">
    <!--=============== gallery css ===============-->
    <link href="<?php echo e(asset("website/css/flaticon.css")); ?>" rel="stylesheet">
    <link href="<?php echo e(asset("website/css/jquery.fancybox.min.css")); ?>" rel="stylesheet">
    <!-- Owl carousel style sheet -->
    <link rel="stylesheet" href="<?php echo e(asset("website/css/owl.carousel.css")); ?>">
    <!-- Owl carousel themes default -->
    <link rel="stylesheet" href="<?php echo e(asset("website/css/owl.theme.default.min.css")); ?>">
    <!--=============== bxslider css ===============-->
    <link href="<?php echo e(asset("website/css/jquery.bxslider.min.css")); ?>" rel="stylesheet">
    <!--=============== Animate css ===============-->
    

    <!--=============== style css ===============-->

    <?php if(currentLang()=='ar'): ?>
        <link href="<?php echo e(assetPath("website/css/swiper.min.css")); ?>" rel="stylesheet">
        <link href="<?php echo e(asset("website/css/style.css")); ?>" rel="stylesheet">
    <?php elseif(currentLang()=='en'): ?>
        <link href="<?php echo e(assetPath("website/css/swiper.min_en.css")); ?>" rel="stylesheet">
        <link href="<?php echo e(asset("website/css/style_en.css")); ?>" rel="stylesheet">
    <?php endif; ?>
    <link href="<?php echo e(asset("website/css/resp-nav.css")); ?>" rel="stylesheet">
    <!---=================== swiper ===================--->

   

    <!-- canonical links-->
    <?php echo $__env->yieldContent('canonical'); ?>

    <?php echo $__env->yieldContent('customizedStyle'); ?>

    <script type="application/ld+json">
        
    </script>
    <!--Define social media profiles with schema.org markup -->
    <script type="application/ld+json">
        {
            "@type" : "Organization",
            "@context" : "http://schema.org",
        }
        "name" : "3elagy",
        "url" : "https://3elagy.com",
        "sameAs" : [
        <?php $__currentLoopData = $sameAs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $same): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            "<?php echo e($same->url); ?>",
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    </script>

    <?php echo $__env->yieldContent('header-code'); ?>

</head>
<body><!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TTBMCRQ"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="wrapper_home">
    <!--Start wrapper_home-->
        <?php echo $__env->make('website.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('website.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</div>

<!-- //footer -->




<!-- JS
============================================ -->
<!-- javascript libraries -->
<!-- JQuery Min JS -->

<!--========== jQuery library ==========-->
<script src="<?php echo e(assetPath("website/js/jquery-3.4.1.min.js")); ?>"></script>
<!--========== bootstrap js ==========-->
<script src="<?php echo e(assetPath("website/js/bootstrap.min.js")); ?>"></script>
<!--========== gallery js ==========-->
<script src="<?php echo e(assetPath("website/js/nav-tool.js")); ?>"></script>
<!--========== bxslider js ==========-->
<script src="<?php echo e(assetPath("website/js/jquery.bxslider.min.js")); ?>"></script>
<!-- Owl Carousel Slider -->
<script src="<?php echo e(assetPath("website/js/owl.carousel.min.js")); ?>"></script>
<!--========== wow js ==========-->
<script src="<?php echo e(assetPath("website/js/wow.min.js")); ?>"></script>

<script src="<?php echo e(assetPath("website/js/slider.js")); ?>"></script>
<script src="<?php echo e(assetPath("website/js/jquery.fancybox.js")); ?>"></script>
<script src="<?php echo e(assetPath("website/js/swiper.min.js")); ?>"></script>
<script src="<?php echo e(assetPath("website/js/particles.js")); ?>"></script>
<script src="<?php echo e(assetPath("website/js/particles.min.js")); ?>"></script>

<!--        <script src='//production-aassets.codepen.io/assets/common/stopExecutionOnTimeout-b2a7b3fe212eaa732349046d8416e00a9dec26eb7fd347590fbced3ab38af52e.js'></script>-->


<!--========== custom js ==========-->
<script src="<?php echo e(assetPath("website/js/custom.js")); ?>"></script>

<?php echo $__env->yieldContent('customizedScript'); ?>

<script type="text/javascript">
    /*(function () {
        var options = {
           /!* facebook: "903445093066230", // Facebook page ID*!/
            whatsapp: "<?php echo e($contact->whatsapp); ?>", // WhatsApp number
            call_to_action: "<?php echo e(__('trans.contact')); ?>", // Call to action
            button_color: "#FF6550", // Color of button
            position: "left", // Position may be 'right' or 'left'
            order: "whatsapp", // Order of buttons
        };
        var proto = document.location.protocol, host = "whatshelp.io", url = proto + "//static." + host;
        var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
        var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
    })();*/
    
    
    
    var service_container=$(".service_item_container");
    //console.log(service_container);
    var wanted_item=$(".service_items:eq(4)");
    console.log(wanted_item);
    wanted_item.insertAfter("li.service_items:eq(0)");
    //$(".21").insertAfter("li.service_items:nth-child(1)");
    //$(".21").insertAfter("li.service_items:eq(1)");
</script>


</body>
</html>
