<?php $__env->startSection('title', 'Dashboard'); ?>
<!-- Drop Your Customized Style Here -->
<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>
<!-- Drop Your Customized Scripts Here -->
<?php $__env->startSection('customizedScript'); ?>

<?php $__env->stopSection(); ?>
<!-- Start of content section -->
<?php $__env->startSection('content'); ?>


    <section class="content-header">
        <h1>
            Video
            <small>Show Album Images</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('album')); ?>">Album</a></li>
            <li class="active">Update Album</li>
        </ol>
    </section>

    <section class="content container-fluid">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <div class="row">
            <?php if($videos): ?>
                <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-3 col-xs-6 thumb">
                        <div class="box-right">
                            <iframe width="100%" height="200" src="<?php echo e($video->url); ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe>
                        </div>
                        <div class="d-flex flex-row">
                            <button class="btn btn-danger" data-toggle="modal" data-target="#delete<?php echo e($video->id); ?>"><i class="fa fa-trash"></i> Delete Video</button>
                            <a href="<?php echo e(adminUrl('video/'.$video->id.'/edit')); ?>" class="btn btn-primary"><i class="fa fa-edit"></i> Edit Video</a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        </div>

        <?php if($videos): ?>
            <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="modal modal-danger fade" id="delete<?php echo e($video->id); ?>">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Delete Video</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are You Sure You Want To Delete Video</p>
                            </div>
                            <div class="modal-footer">
                                <form action="<?php echo e(route('video.destroy', $video->id)); ?>" method="post">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex flex-row">
                                        <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                            cancel
                                        </button>
                                        <button type="submit" class="btn btn-danger">
                                            Delete
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>