<?php $__env->startSection('title', __('trans.about')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('customizedStyle'); ?>
    <style>

    </style>
    <?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        $("li .about-album:first-child").addClass('active');
       $(".item:first-child").addClass('active');

    </script>
    <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>
                                <?php echo e(__("trans.website_title")); ?>

                            </h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="index.html">
                                            <?php echo e(__("trans.home")); ?>

                                        </a></li>
                                    <li><a href="about.html">
                                            <?php echo e(__("trans.about")); ?>

                                        </a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->

    <!--============= Start main_info =============-->
    <section class="main_info">
        <div class="container"><!--Start Container-->
            <div class="row"><!--Start row-->

                <div class="col-md-8 col-xs-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight">
                            
                           <?php echo e(__("trans.perfect_health")); ?>

                            <hr>
                        </h3>
                        <p class="wow fadeInRight" data-wow-duration="1.5s">

                            <?php echo $about->{'about_'.currentLang()}->description; ?>


                        </p>
                    </div>
                </div>

                <div class="col-md-4 col-xs-12">
                    <div id="carousel-example-generic" class="carousel slide wow fadeInLeft" data-ride="carousel">
                        <!-- Indicators -->
                        <ol class="carousel-indicators">
                            <?php if($perfect_health_album): ?>
                                <?php ($count=0); ?>
                                <?php $__currentLoopData = $perfect_health_album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perfect_health): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li data-target="#carousel-example-generic" data-`slide`-to="<?php echo e($count); ?>" class="about-album "></li>
                                    <?php ($count++); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <?php endif; ?>
                           
                        </ol>

                        <!-- Wrapper for slides -->
                        <div class="carousel-inner" role="listbox">
                            <?php if($perfect_health_album): ?>
                                <?php $__currentLoopData = $perfect_health_album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perfect_health): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="item">
                                        <img src="<?php echo e($perfect_health->path); ?>" alt="...">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <?php endif; ?>

                            

                        </div>
                    </div>
                </div>

            </div><!--End row-->
        </div><!--End Container-->
    </section>
    <!--============= End main_info =============-->

    <!--============= Start about_feats =============-->
    <section class="about_feats">
        <div class="overlay"><!--Start overlay-->
            <div class="container"><!--Start Container-->
                <div class="row"><!--Start row-->
                    <?php if($features): ?>
                        <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3 col-sm-6 col-xs-6">
                                <div class="single_feats wow flipInX" data-wow-duration="2s">
                                    <img src="<?php echo e($feature->image->path); ?>" alt="">
                                    <h4><?php echo e($feature->{'feature_'.currentLang()}->title); ?></h4>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <?php endif; ?>

                   

                </div><!--End row-->
            </div><!--End Container-->
        </div><!--End overlay-->
    </section>
    <!--============= End about_feats =============-->

    <!--============= Start nour =============-->
    <section class="nour">
        <div class="container"><!--Start Container-->
            <div class="row"><!--Start row-->

                <div class="col-md-6 col-xs-12">
                    <div class="nour_img project wow fadeInLeft" data-wow-duration="2s">
                        
                        <img src="<?php echo e(assetPath($about->valuesImage->path)); ?>" alt="">
                        <ul class="list-unstyled list-inline">
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-facebook fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-twitter fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-google-plus fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-instagram fa-fw"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-6 col-xs-12">
                    <div class="nour_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1s">
                            
                            <?php echo e(__("trans.about")); ?>

                            <hr>
                        </h3>
                        <?php echo $about->{'about_'.currentLang()}->value; ?>

                        
                    </div>
                </div>

            </div><!--End row-->
        </div><!--End Container-->
    </section>
    <!--============= End nour =============-->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>