<?php
// **********************************************************************// 
// ! Add Theme Support
// **********************************************************************//
function apparatus_setup_theme_supported_gutenberg_features() {
add_theme_support( 'responsive-embeds' );
add_theme_support( 'align-wide' );
add_theme_support( 'wp-block-styles' );
add_theme_support('editor-styles');
// Enqueue editor styles.
add_editor_style( 'gutenberg/css/style-editor.css' );
// Add theme support for selective refresh for widgets.
add_theme_support( 'customize-selective-refresh-widgets' );

add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => esc_html__( 'Primary Color', 'apparatus' ),
					'slug'  => 'primary',
					'color' => apparatus_hsl_hex( 'default' === get_theme_mod( 'colorscheme' ) ? 60 : get_theme_mod( 'colorscheme_primary_hue', 60 ), 81, 60 ),
				),
			)
		);
}
add_action( 'after_setup_theme', 'apparatus_setup_theme_supported_gutenberg_features' );

// **********************************************************************// 
// ! Convert HSL to HEX colors
// **********************************************************************//
function apparatus_hsl_hex( $h, $s, $l, $to_hex = true ) {

	$h /= 360;
	$s /= 100;
	$l /= 100;

	$r = $l;
	$g = $l;
	$b = $l;
	$v = ( $l <= 0.5 ) ? ( $l * ( 1.0 + $s ) ) : ( $l + $s - $l * $s );
	if ( $v > 0 ) {
		$m;
		$sv;
		$sextant;
		$fract;
		$vsf;
		$mid1;
		$mid2;

		$m = $l + $l - $v;
		$sv = ( $v - $m ) / $v;
		$h *= 6.0;
		$sextant = floor( $h );
		$fract = $h - $sextant;
		$vsf = $v * $sv * $fract;
		$mid1 = $m + $vsf;
		$mid2 = $v - $vsf;

		switch ( $sextant ) {
			case 0:
				$r = $v;
				$g = $mid1;
				$b = $m;
				break;
			case 1:
				$r = $mid2;
				$g = $v;
				$b = $m;
				break;
			case 2:
				$r = $m;
				$g = $v;
				$b = $mid1;
				break;
			case 3:
				$r = $m;
				$g = $mid2;
				$b = $v;
				break;
			case 4:
				$r = $mid1;
				$g = $m;
				$b = $v;
				break;
			case 5:
				$r = $v;
				$g = $m;
				$b = $mid2;
				break;
		}
	}
	$r = round( $r * 255, 0 );
	$g = round( $g * 255, 0 );
	$b = round( $b * 255, 0 );

	if ( $to_hex ) {

		$r = ( $r < 15 ) ? '0' . dechex( $r ) : dechex( $r );
		$g = ( $g < 15 ) ? '0' . dechex( $g ) : dechex( $g );
		$b = ( $b < 15 ) ? '0' . dechex( $b ) : dechex( $b );

		$output = '#';
		$output .= esc_attr($r.$g.$b);
		return $output;

	} else {
		$output = 'rgb(';
		$output .= esc_attr($r);
		$output .= ', ';
		$output .= esc_attr($g);
		$output .= ', ';
		$output .= esc_attr($b);
		$output .= ')';
		return $output;
	}
}